%------------------------------------------------------------------------------
% File     : LCL941^5 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Logic Calculi
% Problem  : Goedel translation of ALG014+1 (from TPTP-v5.0.0)
% Version  : [BP13] axioms.
% English  : 

% Refs     : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : GAL014+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.78 v9.1.0, 0.88 v9.0.0, 0.90 v8.2.0, 0.85 v8.1.0
% Syntax   : Number of formulae    :   51 (  11 unt;  21 typ;  10 def)
%            Number of atoms       : 1115 (  10 equ;   0 cnn)
%            Maximal formula atoms :  240 (  37 avg)
%            Number of connectives : 2735 (   1   ~;   1   |;   3   &;2726   @)
%                                         (   1 <=>;   3  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   73 (  13 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   63 (  63   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   21 (  20 usr;   6 con; 0-3 aty)
%            Number of variables   :   45 (  37   ^;   6   !;   2   ?;  45   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $constant,
%            $modalities == $modal_system_S5].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_reflexive,axiom,
    ! [W: mworld] : ( mrel @ W @ W ) ).

thf(mrel_euclidean,axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ W @ U )
        & ( mrel @ W @ V ) )
     => ( mrel @ U @ V ) ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] : ( A @ X @ W ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] : ( A @ X @ W ) ) ) ).

thf(unit_decl,type,
    unit: $i ).

thf(e0_decl,type,
    e0: $i ).

thf(e1_decl,type,
    e1: $i ).

thf(e2_decl,type,
    e2: $i ).

thf(e3_decl,type,
    e3: $i ).

thf(qmltpeq_decl,type,
    qmltpeq: $i > $i > mworld > $o ).

thf(inv_decl,type,
    inv: $i > $i ).

thf(op_decl,type,
    op: $i > $i > $i ).

thf(reflexivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( qmltpeq @ X @ X ) ) ) ) ) ).

thf(symmetry,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(transitivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ Z ) ) ) @ ( mbox @ ( qmltpeq @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(inv_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( inv @ A ) @ ( inv @ B ) ) ) ) ) ) ) ) ) ) ).

thf(op_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( op @ A @ C ) @ ( op @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(op_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( op @ C @ A ) @ ( op @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax1,axiom,
    mlocal @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e3 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e3 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e3 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e3 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e3 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e3 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e3 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e3 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e1 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e1 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e1 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e1 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e2 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e2 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e2 ) @ e3 ) ) ) ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax2,axiom,
    mlocal @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e0 ) @ e0 ) @ ( op @ e0 @ ( op @ e0 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e0 ) @ e1 ) @ ( op @ e0 @ ( op @ e0 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e0 ) @ e2 ) @ ( op @ e0 @ ( op @ e0 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e0 ) @ e3 ) @ ( op @ e0 @ ( op @ e0 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e1 ) @ e0 ) @ ( op @ e0 @ ( op @ e1 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e1 ) @ e1 ) @ ( op @ e0 @ ( op @ e1 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e1 ) @ e2 ) @ ( op @ e0 @ ( op @ e1 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e1 ) @ e3 ) @ ( op @ e0 @ ( op @ e1 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e2 ) @ e0 ) @ ( op @ e0 @ ( op @ e2 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e2 ) @ e1 ) @ ( op @ e0 @ ( op @ e2 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e2 ) @ e2 ) @ ( op @ e0 @ ( op @ e2 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e2 ) @ e3 ) @ ( op @ e0 @ ( op @ e2 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e3 ) @ e0 ) @ ( op @ e0 @ ( op @ e3 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e3 ) @ e1 ) @ ( op @ e0 @ ( op @ e3 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e3 ) @ e2 ) @ ( op @ e0 @ ( op @ e3 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e0 @ e3 ) @ e3 ) @ ( op @ e0 @ ( op @ e3 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e0 ) @ e0 ) @ ( op @ e1 @ ( op @ e0 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e0 ) @ e1 ) @ ( op @ e1 @ ( op @ e0 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e0 ) @ e2 ) @ ( op @ e1 @ ( op @ e0 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e0 ) @ e3 ) @ ( op @ e1 @ ( op @ e0 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e1 ) @ e0 ) @ ( op @ e1 @ ( op @ e1 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e1 ) @ e1 ) @ ( op @ e1 @ ( op @ e1 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e1 ) @ e2 ) @ ( op @ e1 @ ( op @ e1 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e1 ) @ e3 ) @ ( op @ e1 @ ( op @ e1 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e2 ) @ e0 ) @ ( op @ e1 @ ( op @ e2 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e2 ) @ e1 ) @ ( op @ e1 @ ( op @ e2 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e2 ) @ e2 ) @ ( op @ e1 @ ( op @ e2 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e2 ) @ e3 ) @ ( op @ e1 @ ( op @ e2 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e3 ) @ e0 ) @ ( op @ e1 @ ( op @ e3 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e3 ) @ e1 ) @ ( op @ e1 @ ( op @ e3 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e3 ) @ e2 ) @ ( op @ e1 @ ( op @ e3 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e1 @ e3 ) @ e3 ) @ ( op @ e1 @ ( op @ e3 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e0 ) @ e0 ) @ ( op @ e2 @ ( op @ e0 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e0 ) @ e1 ) @ ( op @ e2 @ ( op @ e0 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e0 ) @ e2 ) @ ( op @ e2 @ ( op @ e0 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e0 ) @ e3 ) @ ( op @ e2 @ ( op @ e0 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e1 ) @ e0 ) @ ( op @ e2 @ ( op @ e1 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e1 ) @ e1 ) @ ( op @ e2 @ ( op @ e1 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e1 ) @ e2 ) @ ( op @ e2 @ ( op @ e1 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e1 ) @ e3 ) @ ( op @ e2 @ ( op @ e1 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e2 ) @ e0 ) @ ( op @ e2 @ ( op @ e2 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e2 ) @ e1 ) @ ( op @ e2 @ ( op @ e2 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e2 ) @ e2 ) @ ( op @ e2 @ ( op @ e2 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e2 ) @ e3 ) @ ( op @ e2 @ ( op @ e2 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e3 ) @ e0 ) @ ( op @ e2 @ ( op @ e3 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e3 ) @ e1 ) @ ( op @ e2 @ ( op @ e3 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e3 ) @ e2 ) @ ( op @ e2 @ ( op @ e3 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e2 @ e3 ) @ e3 ) @ ( op @ e2 @ ( op @ e3 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e0 ) @ e0 ) @ ( op @ e3 @ ( op @ e0 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e0 ) @ e1 ) @ ( op @ e3 @ ( op @ e0 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e0 ) @ e2 ) @ ( op @ e3 @ ( op @ e0 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e0 ) @ e3 ) @ ( op @ e3 @ ( op @ e0 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e1 ) @ e0 ) @ ( op @ e3 @ ( op @ e1 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e1 ) @ e1 ) @ ( op @ e3 @ ( op @ e1 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e1 ) @ e2 ) @ ( op @ e3 @ ( op @ e1 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e1 ) @ e3 ) @ ( op @ e3 @ ( op @ e1 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e2 ) @ e0 ) @ ( op @ e3 @ ( op @ e2 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e2 ) @ e1 ) @ ( op @ e3 @ ( op @ e2 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e2 ) @ e2 ) @ ( op @ e3 @ ( op @ e2 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e2 ) @ e3 ) @ ( op @ e3 @ ( op @ e2 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e3 ) @ e0 ) @ ( op @ e3 @ ( op @ e3 @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e3 ) @ e1 ) @ ( op @ e3 @ ( op @ e3 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e3 ) @ e2 ) @ ( op @ e3 @ ( op @ e3 @ e2 ) ) ) ) @ ( mbox @ ( qmltpeq @ ( op @ ( op @ e3 @ e3 ) @ e3 ) @ ( op @ e3 @ ( op @ e3 @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax3,axiom,
    mlocal @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ unit @ e0 ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ unit ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ unit @ e1 ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ unit ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ unit @ e2 ) @ e2 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ unit ) @ e2 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ unit @ e3 ) @ e3 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e3 @ unit ) @ e3 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ unit @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ unit @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ unit @ e2 ) ) @ ( mbox @ ( qmltpeq @ unit @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax4,axiom,
    mlocal @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ ( inv @ e0 ) ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( inv @ e0 ) @ e0 ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ ( inv @ e1 ) ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( inv @ e1 ) @ e1 ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ ( inv @ e2 ) ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( inv @ e2 ) @ e2 ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e3 @ ( inv @ e3 ) ) @ unit ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ ( inv @ e3 ) @ e3 ) @ unit ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e3 ) ) ) ) ) @ ( mand @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e3 ) ) ) ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e0 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e1 ) ) @ ( mor @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax5,axiom,
    mlocal @ ( mbox @ ( qmltpeq @ unit @ e0 ) ) ).

thf(ax6,axiom,
    mlocal @ ( mbox @ ( qmltpeq @ ( inv @ unit ) @ unit ) ) ).

thf(ax7,axiom,
    mlocal @ ( mand @ ( mbox @ ( qmltpeq @ ( inv @ ( inv @ e0 ) ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( inv @ ( inv @ e1 ) ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( inv @ ( inv @ e2 ) ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ ( inv @ e3 ) ) @ e3 ) ) ) ) ) ).

thf(ax8,axiom,
    mlocal @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e0 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e1 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e3 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e0 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e0 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e1 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e3 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e0 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e1 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e3 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e0 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e1 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ e3 ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e3 ) ) @ ( mbox @ ( qmltpeq @ ( inv @ e3 ) @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax9,axiom,
    mlocal @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ ( inv @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ ( inv @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( inv @ e0 ) @ ( inv @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ ( inv @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( inv @ e1 ) @ ( inv @ e3 ) ) ) ) ) @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( inv @ e2 ) @ ( inv @ e3 ) ) ) ) ) ) ) ) ) ) ).

thf(ax10,axiom,
    mlocal @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ ( op @ e1 @ e0 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ ( op @ e2 @ e0 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ ( op @ e3 @ e0 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ ( op @ e2 @ e0 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ ( op @ e3 @ e0 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ ( op @ e3 @ e0 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ ( op @ e1 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ ( op @ e2 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ ( op @ e3 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ ( op @ e2 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ ( op @ e3 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ ( op @ e3 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ ( op @ e1 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ ( op @ e2 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ ( op @ e3 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ ( op @ e2 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ ( op @ e3 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ ( op @ e3 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ ( op @ e1 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ ( op @ e2 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e3 ) @ ( op @ e3 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e3 ) @ ( op @ e2 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e3 ) @ ( op @ e3 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e3 ) @ ( op @ e3 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ ( op @ e0 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ ( op @ e0 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ ( op @ e0 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ ( op @ e0 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e1 ) @ ( op @ e0 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e2 ) @ ( op @ e0 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ ( op @ e1 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ ( op @ e1 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e0 ) @ ( op @ e1 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ ( op @ e1 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ ( op @ e1 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e2 ) @ ( op @ e1 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ ( op @ e2 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ ( op @ e2 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e0 ) @ ( op @ e2 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ ( op @ e2 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e1 ) @ ( op @ e2 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ ( op @ e2 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ ( op @ e3 @ e1 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ ( op @ e3 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e0 ) @ ( op @ e3 @ e3 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e1 ) @ ( op @ e3 @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e1 ) @ ( op @ e3 @ e3 ) ) ) ) ) @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e2 ) @ ( op @ e3 @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ax11,axiom,
    mlocal @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ e0 @ e1 ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ e0 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ e0 @ e3 ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ e1 @ e2 ) ) ) ) @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ e1 @ e3 ) ) ) ) @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ e2 @ e3 ) ) ) ) ) ) ) ) ) ).

thf(co1,conjecture,
    mlocal @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e0 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e0 ) ) ) ) ) @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e1 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e1 ) ) ) ) ) @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e2 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e2 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e2 ) ) ) ) ) @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e3 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e3 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e3 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e3 ) ) ) ) ) @ ( mbox @ ( mnot @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e0 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e0 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e0 ) ) ) ) ) @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e1 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e1 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e1 ) ) ) ) ) @ ( mor @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e2 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e2 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e2 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e2 ) ) ) ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e0 @ e0 ) @ e3 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e1 @ e1 ) @ e3 ) ) @ ( mand @ ( mbox @ ( qmltpeq @ ( op @ e2 @ e2 ) @ e3 ) ) @ ( mbox @ ( qmltpeq @ ( op @ e3 @ e3 ) @ e3 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

%------------------------------------------------------------------------------
